﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="CustTickets.aspx.cs" Inherits="PirTickets.CustTickets" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register TagPrefix="oajax" Namespace="OboutInc" Assembly="obout_AJAXPage" %>
<%@ Register TagPrefix="oem" Namespace="OboutInc.EasyMenu_Pro" Assembly="obout_EasyMenu_Pro" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <asp:TabContainer ID="TabContainer1" runat="server" ActiveTabIndex="0" TabStripPlacement="Top">
         <asp:TabPanel ID="TabPanel1" runat="server" HeaderText="New Repairs">
            <ContentTemplate>
                <asp:Label ID="Label1" runat="server" Text="These are the repairs you have outstanding:"></asp:Label>
                <br />
                <br />
                <cc1:Grid ID="GridRepairs" runat="server" AllowPaging="True" AllowAddingRecords="False"
                    AutoGenerateSelectButton="True" DataKeyNames="OrderID" OnSelect="GridRepairs_SelectedIndexChanged"
                    Width="716px" AllowSorting="True" AutoGenerateColumns="False" DataSourceID="SqlDataCustTickets" PageSize="20" PageSizeOptions="20,40,50"
                    EmptyDataText="You have no repairs to view" AutoPostBackOnSelect="true" AllowFiltering="False" FolderStyle="~/Styles/style_9">
                    <Columns>
                        
                        <cc1:Column HeaderText="" Index="0" Width="60px" Visible="true">
                            <TemplateSettings TemplateId="tempView" />
                        </cc1:Column>
                        <cc1:Column DataField="OrderID" HeaderText="ID" SortExpression="OrderID" Index="1" Width="60px" Visible="true">
                        </cc1:Column>
                        <cc1:Column DataField="manufacturer" HeaderText="Manufacturer" SortExpression="manufacturer" Width="100px" Index="1" />
                        <cc1:Column DataField="ModelName" HeaderText="ModelName" SortExpression="ModelName" Index="2" Width="100px" />
                        <cc1:Column DataField="SerialNumber" HeaderText="SerialNumber" ReadOnly="True" SortExpression="SerialNumber" Index="3" Width="100px" />
                        <cc1:Column DataField="Received" HeaderText="Received" ReadOnly="True" DataFormatString="{0:dd MMM yyyy}" SortExpression="Received" Index="4" Width="90px" />
                        
                        <cc1:Column DataField="status_name" HeaderText="Status" ReadOnly="True" SortExpression="Status" Index="7" Width="150px" />
                    </Columns>
                    <Templates>
                        <cc1:GridTemplate runat="server" ID="tempView">
                            <Template>
                                <a href='CustTicketForm.aspx?repID=<%# Container.DataItem["OrderID"] %>' target="_blank">
                                    <asp:Label ID="lblId" runat="server" Text='View' />
                                </a>
                            </Template>
                        </cc1:GridTemplate>
  
                     </Templates>
                </cc1:Grid>
            </ContentTemplate>
        </asp:TabPanel>
        <asp:TabPanel ID="TabPanel2" runat="server" HeaderText="Completed Repairs">
            <ContentTemplate>
                <asp:Label ID="Label2" runat="server" Text="These are the repairs that we have completed for you:"></asp:Label>
                <br />
                <br />
                <cc1:Grid ID="GridRepairsComplete" runat="server" AllowPaging="True" AllowAddingRecords="False"
                    AutoGenerateSelectButton="True" DataKeyNames="OrderID" OnSelect="GridRepairsComplete_Select"
                    Width="730px" AllowSorting="True" AutoGenerateColumns="False" DataSourceID="SqlDataCustTicketsComplete" PageSize="20" PageSizeOptions="20,40,50"
                    EmptyDataText="You have no repairs to view" AutoPostBackOnSelect="true" AllowFiltering="False" FolderStyle="~/Styles/style_9">
                    <Columns>
                        <cc1:Column HeaderText="" Index="0" Width="60px" Visible="true">
                            <TemplateSettings TemplateId="tempViewRep" />
                        </cc1:Column>
                        <cc1:Column DataField="OrderID" HeaderText="ID" SortExpression="OrderID" Index="1" Width="60px" Visible="true">
                        </cc1:Column>
                        <cc1:Column DataField="manufacturer" HeaderText="Manufacturer" SortExpression="manufacturer" Width="100px" Index="2" />
                        <cc1:Column DataField="ModelName" HeaderText="ModelName" SortExpression="ModelName" Index="3" Width="100px" />
                        <cc1:Column DataField="SerialNumber" HeaderText="SerialNumber" ReadOnly="True" SortExpression="SerialNumber" Index="4" Width="100px" />
                        <cc1:Column DataField="Received" HeaderText="Received" ReadOnly="True" DataFormatString="{0:dd MMM yyyy}" SortExpression="Received" Index="5" Width="90px" />
                        
                        <cc1:Column DataField="status_name" HeaderText="Status" ReadOnly="True" SortExpression="Status" Index="7" Width="150px" />
                        
                    </Columns>
                    <Templates>
                        <cc1:GridTemplate runat="server" ID="tempViewRep">
                            <Template>
                                <a href='CustTicketForm.aspx?repID=<%# Container.DataItem["OrderID"] %>' target="_blank">
                                    <asp:Label ID="lblId" runat="server" Text='View' />
                                </a>
                            </Template>
                        </cc1:GridTemplate>
                        <cc1:GridTemplate runat="server" ID="viewOrder">   
                            <Template>                                                                        
                                <a href='CustTicketForm.aspx?repID=<%# Container.DataItem["OrderID"] %>' target="_blank">
                                    <asp:Label ID="lblId" runat="server" Text='<%# Container.DataItem["OrderID"] %>' />
                                </a>
                            </Template>
                        </cc1:GridTemplate>
                    </Templates>
                </cc1:Grid>
            </ContentTemplate>
        </asp:TabPanel>
    </asp:TabContainer>

    <asp:SqlDataSource ID="SqlDataCustTickets" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT [OrderID], [manufacturer], [ModelName], [SerialNumber], [Received], [RepairCompleted], [priority_name], [status_name] FROM [dbo].[vwCustomerTickets] WHERE [CustomerID] = @CustomerID and (RepairCompleted=0 or RepairCompleted is null) and (UneconomicalToRepair = 0 or UneconomicalToRepair is null)">
        <SelectParameters>
            <asp:SessionParameter Name="CustomerID" SessionField="custid" Type="String" />
        </SelectParameters>
    </asp:SqlDataSource>
    <asp:SqlDataSource ID="SqlDataCustTicketsComplete" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT [OrderID], [manufacturer], [ModelName], [SerialNumber], [Received], [RepairCompleted], [priority_name], [status_name] FROM [dbo].[vwCustomerTickets] WHERE ([CustomerID] = @CustomerID and (RepairCompleted=1 or UneconomicalToRepair=1))">
        <SelectParameters>
            <asp:SessionParameter Name="CustomerID" SessionField="custid" Type="String" />
        </SelectParameters>
    </asp:SqlDataSource>
</asp:Content>
